<?LassoScript

	// This page lists the existing polls.
	//
	// Each poll is shown along with its title, question, the code that is required to 
	// place the poll on a Web site and a summary of the current status of the poll.
	// Links allow each poll to be edited and allow a new poll to be created.
	
?>
<h2>Lasso Quick Poll</h2>
<div class="group_list" id="page_frame"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
	<div class="group"><b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
		<div class="group_title">
			Home
		</div>
		[inline: -log=$log_level,
				-search,
				-database='op_quick_poll',
				-table='polls',
				-keyfield='id',
				-maxrecords='all',
				-sortfield='id']
			[records]
				<div class="item">
					<div class="item_title"><a href="index.lasso?poll=[field: 'id']">[encode_html: (if_empty: (field: 'title'),'(Untitled Poll)')]</a></div>
					<div class="item_details">
						<b>[field: 'question']</b>
						<br />
						[if: (field: 'status') == 'true']This poll is visible.[else]This poll is currently hidden.  Only administrators will be able to see this poll.[/if]
						[if: (field: 'current') == 'true']This is the current poll.  It will show up by default if no code is specified
						in the &lt;script /&gt; block.[/if]
						[inline: -log=$log_level,
								-search,
								-database='op_quick_poll', 
								-table='answers',
								-keyfield='id',
								-op='eq', 'poll_id' = (var: 'poll_id'),
								-sortfield='sort',
								-maxrecords='all']
							[var: 'total' = 0][records][$total += (integer: (field: 'result'))][/records]
							[if: $total == 0]This poll does not have any votes yet.[else]This poll has [var: 'total'] votes.[/if]
						[/inline]
						[if: (field: 'archive') == true]
							This poll has been archived. It is no longer open for voting.
						[/if]
						Place the following code on your Web site in order to show this poll:
					</div>
					<div class="item_code">[encode_html: 
						'<!-- Quick Poll - ' + (field: 'code') + ' -->\r\n' +
						'<script src="http://' + server_name + response_path + 'display/poll.lasso?poll=' + (field: 'code') + '" type="text/javascript" />\r\n' +
						'<!-- Quick Poll - End -->\r\n\r\n'
					]</div>
					<br />
				</div>
			[/records]
			[if: (found_count == 0)]
				<div class="item">
					<div class="item_title">No Polls Defined</div>
					<div class="item_details">
						No polls have been created. Use the link below to create a poll.
					</div>
				</div>
			[else]
				<div class="item">
					<div class="item_title">Current Poll</div>
					<div class="item_details">
						Place the following code on your Web site in order to show the current poll:
					</div>
					<div class="item_code">[encode_html: 
						'<!-- Quick Poll - Current -->\r\n' +
						'<script src="http://' + server_name + response_path + 'display/poll.lasso" type="text/javascript" />\r\n' +
						'<!-- Quick Poll - End -->\r\n\r\n'
					]</div>
					<br />
				</div>
			[/if]
		[/inline]
	</div>
	<div class="group">
		<div class="group_title"><a href="index.lasso?poll=new">Create New Poll</a></div>
	</div>
</div>
